<?php
/* --------------------------------------------------------------
   TrackingCodeSortings.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlSortings;
use Traversable;

/**
 * Class TrackingCodeSortings
 *
 * @package Gambio\Admin\TrackingCode\SqlCriteria
 */
class TrackingCodeSortings implements SqlSortings
{
    /**
     * @var TrackingCodeSorting[]
     */
    private $sortings;
    
    
    /**
     * TrackingCodeSortings constructor.
     *
     * @param TrackingCodeSorting ...$sortings
     */
    private function __construct(TrackingCodeSorting ...$sortings)
    {
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param TrackingCodeSorting ...$sortings
     *
     * @return TrackingCodeSortings
     */
    public static function create(TrackingCodeSorting ...$sortings): TrackingCodeSortings
    {
        return new self(...$sortings);
    }
    
    
    /**
     * @param TrackingCodeSorting ...$sortings
     *
     * @return $this
     */
    public function add(TrackingCodeSorting ...$sortings): self
    {
        $this->sortings = array_merge($this->sortings, $sortings);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->sortings);
    }
}